import { Inject, Injectable } from '@nestjs/common';
import { FwkCacheService } from 'src/framework/application';
import { PrimeLogger } from '../../definition';
import { CACHE_MANAGER, Cache } from '@nestjs/cache-manager';

export enum CacheManagerEnum {
  FIND_ALL_MATCHING_WORD = 'FIND_ALL_MATCHING_WORD',
  FIND_ONE_MATCHING_WORD = 'FIND_ONE_MATCHING_WORD_KEY',
  FIND_ALL_AGILE_DASHBOARD = 'FIND_ALL_AGILE_DASHBOARD_KEY',
  SUBDIVISIONS_BY_COMPANY_ID = 'SUBDIVISIONS_BY_COMPANY_ID_KEY',
  FIND_COMPANY_BY_ID = 'FIND_COMPANY_BY_ID_KEY',
  USER_ROLES = 'USER_ROLES_KEY',
  IDS_ACTIVE_COMPANIES = 'IDS_ACTIVE_COMPANIES_KEY',
  COUNT_ACTIVE_USERS = 'COUNT_ACTIVE_USERS_KEY',
  COUNT_ACTIVE_TENDERS = 'COUNT_ACTIVE_TENDERS_KEY',
}

@Injectable()
export class FwkCacheServiceImpl implements FwkCacheService {
  private readonly LOGGER = new PrimeLogger(FwkCacheServiceImpl.name);
  constructor(@Inject(CACHE_MANAGER) private cacheManager: Cache) {}
  static createKey(baseKey: string, params: any[]): string {
    return `${baseKey}:${params.join(';')}`;
  }
  async getOrSet<T>(
    key: string,
    fetchFn: () => Promise<T>,
  ): Promise<T> {
    this.LOGGER.log(`Cache getOrSet key: ${key}`);
    const cached = await this.cacheManager.get<T>(key);
    if (cached) {
        this.LOGGER.log(`Cache hit for key: ${key}`);
        return cached;
    }

    const result = await fetchFn();
    if (result) {
        this.LOGGER.log(`Cache set for key: ${key}`);
        await this.cacheManager.set(key, result);
    }

    return result;
  }
  async del(key: string): Promise<void> {
    this.cacheManager.stores.forEach(store => {
      store.clear();
    });
  }
}
