import { Inject, Injectable } from '@nestjs/common';
import { NotificationRecordService } from 'src/framework/application/service/notification-record-service/notification-record-service.interface';
import { NotificationRecord, InsertNotificationRecord, UpdateNotificationRecord } from 'src/framework/domain';
import { TxType } from '../../drizzle';
import { PrimeLogger } from '../../definition';
import { NotificationRecordRepository } from 'src/framework/application/repository/notification-record-repository/notification-record-repository.interface';

@Injectable()
export class NotificationRecordServiceImpl implements NotificationRecordService {
    private readonly LOGGER = new PrimeLogger(NotificationRecordServiceImpl.name);
    constructor(@Inject('NotificationRecordRepository') private readonly notificationRecordRepository: NotificationRecordRepository) {}
    erraseNotificationRecordsByTender(tenderIds: number[], tx?: TxType): Promise<void> {
        this.LOGGER.log(`Erasing notification records for tenders with IDs: ${tenderIds.join(', ')}`);
        return this.notificationRecordRepository.erraseNotificationRecordsByTender(tenderIds, tx);
    }
    getNotificationRecordsPaginated(userId: number, page: number, pageSize: number): Promise<NotificationRecord[]> {
        this.LOGGER.log(`Fetching notification records for user ${userId}, page ${page}, pageSize ${pageSize}`);
        return this.notificationRecordRepository.getNotificationRecordsPaginated(userId, page, pageSize);
    }
    getUserNotificationRecordsActive(): Promise<NotificationRecord[]> {
        this.LOGGER.log('Fetching active user notification records');
        return this.notificationRecordRepository.getUserNotificationRecordsActive();
    }
    getAdminNotification(): Promise<NotificationRecord[]> {
        this.LOGGER.log('Fetching admin notification records');
        return this.notificationRecordRepository.getAdminNotification();
    }
    saveAll(notificationRecords: InsertNotificationRecord[], tx?: TxType): Promise<void> {
        this.LOGGER.log(`Saving ${notificationRecords.length} notification records`);
        return this.notificationRecordRepository.saveAll(notificationRecords, tx);
    }
    updateNotification(notificationRecordId: number, notificationRecord: UpdateNotificationRecord, tx?: TxType): Promise<void> {
        this.LOGGER.log(`Updating notification record with ID ${notificationRecordId}`);
        return this.notificationRecordRepository.updateNotification(notificationRecordId, notificationRecord, tx);
    }
    getActiveNotificationRecords(userId: number, isAdmin?: boolean): Promise<NotificationRecord[]> {
        this.LOGGER.log(`Fetching active notification records for user ${userId}, isAdmin: ${isAdmin}`);
        return this.notificationRecordRepository.getActiveNotificationRecords(userId, isAdmin);
    }
    logicalRemoveBYListId(notificationRecordIds: number[], tx?: TxType): Promise<void> {
        this.LOGGER.log(`Logically removing notification records with IDs: ${notificationRecordIds.join(', ')}`);
        return this.notificationRecordRepository.logicalRemoveBYListId(notificationRecordIds, tx);
    }
    markNotificationEmailAsSent(notificationRecordId: number[], tx?: TxType): Promise<void> {
        this.LOGGER.log(`Marking notification records as email sent for IDs: ${notificationRecordId.join(', ')}`);
        return this.notificationRecordRepository.markNotificationEmailAsSent(notificationRecordId, tx);
    }
}
