import { Inject, Injectable } from '@nestjs/common';
import { UserCampaignsService } from 'src/framework/application';
import { PrimeLogger } from '../../definition';
import { UserCampaignsRepository } from 'src/framework/application/repository/user-campaigns-repository/user-campaigns-repository.interface';
import { InsertUserCampaign, UpdateUserCampaign, UserCampaign } from 'src/framework/domain';

@Injectable()
export class UserCampaignsServiceImpl implements UserCampaignsService {
    private readonly LOGGER = new PrimeLogger(UserCampaignsServiceImpl.name);
    constructor(
        @Inject('UserCampaignsRepository') private readonly userCampaignsRepository: UserCampaignsRepository,
    ) {}
    getActiveCampaigns(): Promise<UserCampaign[]> {
        this.LOGGER.log('Getting active user campaigns...');
        return this.userCampaignsRepository.getActiveCampaigns();
    }
    create(data: InsertUserCampaign): Promise<UserCampaign | null | undefined> {
        this.LOGGER.log('Creating user campaign...');
        return this.userCampaignsRepository.create(data);
    }
    update(data: UpdateUserCampaign): Promise<string> {
        this.LOGGER.log('Updating user campaign...');
        return this.userCampaignsRepository.update(data);
    }
    getPagination(page: number, pageSize: number, filter?: string): Promise<UserCampaign[]> {
        this.LOGGER.log(`Getting paginated user campaigns - page: ${page}, pageSize: ${pageSize}, filter: ${filter}`);
        return this.userCampaignsRepository.getPagination(page, pageSize, filter);
    }
    logicalRemove(campaignId: number): Promise<void> {
        this.LOGGER.log(`Logical removing user campaign with ID: ${campaignId}`);
        return this.userCampaignsRepository.logicalRemove(campaignId);
    }

}

