import { HttpModule } from '@nestjs/axios';
import { Module } from '@nestjs/common';
import { ConfigModule, ConfigService } from '@nestjs/config';
import { MercadoPublicoGirosRepository } from './mercado-publico-giros.repository';
import { MercadoPublicoGirosHttpConfigService } from './mp-giros.http';

@Module({
  imports: [
    ConfigModule,
    HttpModule.registerAsync({
      imports: [ConfigModule],
      useClass: MercadoPublicoGirosHttpConfigService,
      inject: [ConfigService],
    }),
  ],
  providers: [MercadoPublicoGirosRepository],
  exports: [MercadoPublicoGirosRepository],
})
export class MercadoPublicoGirosModule {}
