import { ApiProperty } from '@nestjs/swagger';
import { z } from 'zod';
interface Comprador {
  CodigoOrganismo: string;
  NombreOrganismo: string;
  RutUnidad: string;
  CodigoUnidad: string;
  NombreUnidad: string;
  DireccionUnidad: string;
  ComunaUnidad: string;
  RegionUnidad: string;
  RutUsuario: string;
  CodigoUsuario: string;
  NombreUsuario: string;
  CargoUsuario: string;
}

interface Fechas {
  FechaCreacion: string;
  FechaCierre: string | undefined;
  FechaInicio: string;
  FechaFinal: string;
  FechaPubRespuestas: string;
  FechaActoAperturaTecnica: string;
  FechaActoAperturaEconomica: string;
  FechaPublicacion: string;
  FechaAdjudicacion: string;
  FechaEstimadaAdjudicacion: string;
  FechaSoporteFisico: string | undefined;
  FechaTiempoEvaluacion: string | undefined;
  FechaEstimadaFirma: string;
  FechasUsuario: string | undefined;
  FechaVisitaTerreno: string | undefined;
  FechaEntregaAntecedentes: string | undefined;
}

enum AdjudicacionTipoEnum {
  AUTORIZACION = 1,
  RESOLUCION = 2,
  ACUERDO = 3,
  DECRETO = 4,
  OTROS = 5,
}

interface Adjudicacion {
  Tipo: AdjudicacionTipoEnum | undefined;
  Fecha: string | undefined;
  Numero: string | undefined;
  NumeroOferentes: number;
  UrlActa: string;
}

interface Item {
  Correlativo: number;
  CodigoProducto: number;
  CodigoCategoria: string;
  Categoria: string;
  NombreProducto: string;
  Descripcion: string;
  UnidadMedida: string;
  Cantidad: number;
  Adjudicacion: string | undefined;
}

interface Items {
  Cantidad: number;
  Listado: Item[];
}

enum MonedaEnum {
  CLP = 'CLP',
  CLF = 'CLF',
  USD = 'USD',
  UTM = 'UTM',
  EUR = 'EUR',
}

enum ModalidadPagoEnum {
  PAGO_30_DIAS = 1,
  PAGO_30_60_90_DIAS = 2,
  PAGO_AL_DIA = 3,
  PAGO_ANUAL = 4,
  PAGO_BIMENSUAL = 5,
  PAGO_CONTRA_ENTREGA_CONFORME = 6,
  PAGOS_MENSUALES = 7,
  PAGO_POR_ESTADO_DE_AVANCE = 8,
  PAGO_TRIMESTRAL = 9,
  PAGO_60_DIAS = 10,
}

enum UnidadTiempoEnum {
  HORAS = 1,
  DIAS = 2,
  SEMANAS = 3,
  MESES = 4,
  ANOS = 5,
}

enum TipoEnum {
  L1 = 'L1',
  LE = 'LE',
  LP = 'LP',
  LQ = 'LQ',
  LR = 'LR',
  E2 = 'E2',
  CO = 'CO',
  B2 = 'B2',
  H2 = 'H2',
  I2 = 'I2',
  LS = 'LS',
}

interface Listado {
  CodigoExterno: string;
  Nombre: string;
  CodigoEstado: number;
  Descripcion: string;
  FechaCierre: string | undefined;
  Estado: string;
  Comprador: Comprador;
  DiasCierreLicitacion: string;
  Informada: boolean;
  CodigoTipo: number;
  Tipo: TipoEnum;
  TipoConvocatoria: number;
  Moneda: MonedaEnum;
  Etapas: number;
  EstadoEtapas: string;
  TomaRazon: number;
  EstadoPublicidadOfertas: number;
  JustificacionPublicidad: string;
  Contrato: number;
  Obras: number;
  CantidadReclamos: number;
  Fechas: Fechas;
  UnidadTiempoEvaluacion: UnidadTiempoEnum;
  DireccionVisita: string;
  DireccionEntrega: string;
  Estimacion: number;
  FuenteFinanciamiento: string;
  VisibilidadMonto: boolean;
  MontoEstimado: number | undefined;
  Tiempo: string | undefined;
  UnidadTiempo: UnidadTiempoEnum;
  Modalidad: ModalidadPagoEnum;
  TipoPago: string;
  NombreResponsablePago: string;
  EmailResponsablePago: string;
  NombreResponsableContrato: string;
  EmailResponsableContrato: string;
  FonoResponsableContrato: string;
  ProhibicionContratacion: string;
  SubContratacion: boolean;
  UnidadTiempoDuracionContrato: number;
  TiempoDuracionContrato: string;
  TipoDuracionContrato: string;
  JustificacionMontoEstimado: string | undefined;
  ObservacionContract: string | undefined;
  ExtensionPlazo: boolean;
  EsBaseTipo: boolean;
  UnidadTiempoContratoLicitacion: string;
  ValorTiempoRenovacion: string;
  PeriodoTiempoRenovacion: string;
  EsRenovable: boolean;
  Adjudicacion: Adjudicacion;
  Items: Items;
}

class LicitacionesResponse {
  Cantidad: number;
  FechaCreacion: string;
  Version: string;
  Listado: Listado[];

  static fromJson(data: LicitacionesResponse): LicitacionesResponse {
    data.Listado = data.Listado.map((item) => {
      item.Informada = (item.Informada as unknown as number) === 1;
      item.VisibilidadMonto =
        (item.VisibilidadMonto as unknown as number) === 1;
      item.SubContratacion = (item.SubContratacion as unknown as number) === 1;
      item.ExtensionPlazo = (item.ExtensionPlazo as unknown as number) === 1;
      item.EsBaseTipo = (item.EsBaseTipo as unknown as number) === 1;
      item.EsRenovable = (item.EsRenovable as unknown as number) === 1;
      return item;
    });
    return data;
  }
}

class AgileTenderTO {
  @ApiProperty({
    description: 'Agile Tender id',
    example: 1,
  })
  id: number;
  @ApiProperty({
    description: 'Agile Tender code',
    example: '1111-111-A111',
  })
  codigo: string;
  @ApiProperty({
    description: 'Name',
    example: '1111-111-A111',
  })
  nombre: string;
  @ApiProperty({
    description: 'Date formatted publication',
    example: '1111-111-A111',
  })
  fecha_publicacion: string;
  @ApiProperty({
    description: 'Date formatted close',
    example: '1111-111-A111',
  })
  fecha_cierre: string;
  @ApiProperty({
    description: 'Organism',
    example: '1111-111-A111',
  })
  organismo: string;
  @ApiProperty({
    description: 'Unit',
    example: '1111-111-A111',
  })
  unidad: string;
  @ApiProperty({
    description: 'Agile state',
    example: 1,
  })
  id_estado: number;
  @ApiProperty({
    description: 'Estado',
    example: '1111-111-A111',
  })
  estado: string;
  @ApiProperty({
    description: 'Amount',
    example: 1,
  })
  monto_disponible: number;
  @ApiProperty({
      description: 'MonedaEnum',
      enum: MonedaEnum,
      enumName: 'MonedaEnum',
    })
  moneda: MonedaEnum;
  @ApiProperty({
    description: 'Amount in clp',
    example: 1,
  })
  monto_disponible_CLP: number;
  @ApiProperty({
    description: 'Date of last change',
    example: '1111-111-A111',
    required: false,
  })
  fecha_cambio: string | null;
  @ApiProperty({
    description: 'Value of currency exchange',
    example: 1,
    required: false,
  })
  valor_cambio_moneda: number | null;
  @ApiProperty({
    description: 'Number of suppliers quoting',
    example: 1,
  })
  cantidad_proveedores_cotizando: number;
  @ApiProperty({
    description: 'State of the call',
    example: 1,
  })
  estado_convocatoria: number;
  @ApiProperty({
    description: 'Last update date',
    example: '1991-01-01T00:00:00.000Z',
    type: Date,
    required: false,
  })
  lastUpdatedAt?: Date | null;
  
  @ApiProperty({
    description: 'Agile bussiness id',
    example: 1,
    required: false,
    type: Number,
  })
  tenderAgileId?: number | null;

  @ApiProperty({
    description: 'Close date',
    example: '1991-01-01T00:00:00.000Z',
    type: Date,
    required: false,
  })
  closeDate?: Date | null;
}

class PageAgileTenderPayload {
  @ApiProperty({
    description: 'Total results',
    example: 1,
  })
  resultCount: number;
  @ApiProperty({
    description: 'Total pages',
    example: 1,
  })
  pageCount: number;
  @ApiProperty({
    description: 'Current page',
    example: 1,
  })
  page: number;
  @ApiProperty({
    description: 'Page size',
    example: 10,
  })
  pageSize: number;
  @ApiProperty({
    description: 'Agile Tender Results',
    type: [AgileTenderTO],
    isArray: true,
  })
  resultados: AgileTenderTO[];
}

class AgileTenderPageResponse {

  @ApiProperty({
    description: 'Success',
    example: 'true',
  })
  success: string;
  @ApiProperty({
    description: 'Success',
    example: 'true',
  })
  trace: string;
  @ApiProperty({
    description: 'Trace',
    example: '',
  })
  errores: string;
  @ApiProperty({
    description: 'Agile Tender Page Payload',
    type: PageAgileTenderPayload,
  })
  payload: PageAgileTenderPayload;

  static fromJson(data: AgileTenderPageResponse): AgileTenderPageResponse {
    /*data.payload = data.payload.resultados.map((item) => {
      console.log('recuento:', item);
      return item;
    });*/
    return data;
  }
}

class MatchWordTO {
  @ApiProperty({
      description: 'word to match',
      required: true,
      type: () => [String],
    })
  words: string[];
}

enum EstadoQueryEnum {
  PUBLICADA = 'Publicada',
  CERRADA = 'Cerrada',
  DESIERTA = 'Desierta',
  ADJUDICADA = 'Adjudicada',
  REVOCADA = 'Revocada',
  SUSPENDIDA = 'Suspendida',
  ACTIVAS = 'activas',
}

// DETAIL INFO AGILE TENDER

class InformacionInstitucionTO {
  @ApiProperty({
    description: 'Buyer organization',
    example: 'I MUNICIPALIDAD DE SAN PEDRO DE ATACAMA',
  })
  organismo_comprador: string;

  @ApiProperty({
    description: 'Buyer organization RUT',
    example: '70.816.700-2',
  })
  rut_organismo_comprador: string;

  @ApiProperty({
    description: 'Division',
    example: 'Depto. de Salud',
  })
  division: string;
}

class ProductoSolicitadoTO {
  @ApiProperty({
    description: 'Product code',
    example: 43233501,
  })
  codigo_producto: number;

  @ApiProperty({
    description: 'Product name',
    example: 'Software de correo electrónico',
  })
  nombre: string;

  @ApiProperty({
    description: 'Product description',
    example: 'Renovación incluye 22 cuentas de correo...',
  })
  descripcion: string;

  @ApiProperty({
    description: 'Quantity',
    example: 22,
  })
  cantidad: number;

  @ApiProperty({
    description: 'Unit of measure',
    example: 'EA',
  })
  unidad_medida: string;
}

class DetailAgileTenderTO {
  @ApiProperty({
    description: 'Detail ID',
    example: 4942775,
  })
  detalle_id: number;

  @ApiProperty({
    description: 'Tender code',
    example: '4999-129-COT25',
  })
  codigo: string;

  @ApiProperty({
    description: 'Tender name',
    example: 'Renovación de servidor VPS y cuentas de correo WorkSpace Google',
  })
  nombre: string;

  @ApiProperty({
    description: 'Tender description',
    example: 'El Departamento de Salud, requiere para la planificación...',
  })
  descripcion: string;

  @ApiProperty({
    description: 'Publication date formatted',
    example: '2025-11-17 12:05',
  })
  fecha_publicacion: string;

  @ApiProperty({
    description: 'Close date formatted',
    example: '2025-11-19 13:00',
  })
  fecha_cierre: string;

  @ApiProperty({
    description: 'State ID',
    example: 2,
  })
  id_estado: number;

  @ApiProperty({
    description: 'State description',
    example: 'Publicada',
  })
  estado: string;

  @ApiProperty({
    description: 'Delivery address',
    example: 'Calle Toconao #413',
    required: false,
  })
  direccion_entrega?: string;

  @ApiProperty({
    description: 'Delivery term in days',
    example: 4,
    required: false,
  })
  plazo_entrega?: number;

  @ApiProperty({
    description: 'Estimated budget',
    example: 1,
    required: false,
  })
  presupuesto_estimado?: number;

  @ApiProperty({
    description: 'Currency',
    enum: MonedaEnum,
    enumName: 'MonedaEnum',
  })
  moneda: MonedaEnum;

  @ApiProperty({
    description: 'Cancellation reason',
    example: null,
    required: false,
  })
  motivo_cancelacion?: string | null;

  @ApiProperty({
    description: 'Cancellation date',
    example: null,
    required: false,
  })
  fecha_cancelacion?: string | null;

  @ApiProperty({
    description: 'Fine or sanction',
    example: 1,
    required: false,
  })
  multa_sancion?: number;

  @ApiProperty({
    description: 'Number of invited suppliers',
    example: 0,
  })
  cantidad_proveedores_invitados: number;

  @ApiProperty({
    description: 'Requested products',
    type: [ProductoSolicitadoTO],
  })
  productos_solicitados: ProductoSolicitadoTO[];

  @ApiProperty({
    description: 'Institution information',
    type: InformacionInstitucionTO,
  })
  informacion_institucion: InformacionInstitucionTO;

  @ApiProperty({
    description: 'Purchase order ID',
    example: null,
    required: false,
  })
  id_orden_compra?: number | null;

  @ApiProperty({
    description: 'First call close date',
    example: '2025-11-19 13:00',
  })
  fecha_cierre_primer_llamado: string;

  @ApiProperty({
    description: 'Second call close date',
    example: null,
    required: false,
  })
  fecha_cierre_segundo_llamado?: string | null;

  @ApiProperty({
    description: 'Budget type',
    example: 'Estimado',
  })
  tipo_presupuesto: string;

  @ApiProperty({
    description: 'Call state',
    example: 1,
  })
  estado_convocatoria: number;

  @ApiProperty({
    description: 'Selection reason',
    example: null,
    required: false,
  })
  motivo_seleccion?: string | null;

  @ApiProperty({
    description: 'Selection criteria',
    example: null,
    required: false,
  })
  criterio_seleccion?: string | null;

  @ApiProperty({
    description: 'Total demands',
    example: 0,
  })
  total_demandas: number;

  @ApiProperty({
    description: 'Total received offers',
    example: 1,
  })
  total_ofertas_recibidas: number;

  @ApiProperty({
    description: 'Desert reason',
    example: null,
    required: false,
  })
  motivo_desierta?: string | null;

  @ApiProperty({
    description: 'Considers environmental requirements',
    example: false,
  })
  considera_requisitos_medioambientales: boolean;

  @ApiProperty({
    description: 'Considers social economic impact requirements',
    example: false,
  })
  considera_requisitos_impacto_social_economico: boolean;
}

class AgileTenderDetailResponse {
  @ApiProperty({
    description: 'Success',
    example: 'true',
  })
  success: string;
  @ApiProperty({
    description: 'Trace',
    example: '',
  })
  trace: string;
  @ApiProperty({
    description: 'Errors',
    example: '',
  })
  errores: string;
  @ApiProperty({
    description: 'Agile Tender Detail Payload',
    type: DetailAgileTenderTO,
  })
  payload: DetailAgileTenderTO;
}

const LicitacionesQueryParamsSchema = z
  .object({
    codigo: z.string().optional(),
    fecha: z.string().optional(),
    estado: z.nativeEnum(EstadoQueryEnum).optional(),
    CodigoOrganismo: z.string().optional(),
    CodigoProveedor: z.string().optional(),
  })
  .refine(
    (data) => {
      const keys: (keyof typeof data)[] = [
        'codigo',
        'fecha',
        'estado',
        'CodigoOrganismo',
        'CodigoProveedor',
      ];
      const providedKeys = keys.filter((key) => data[key] !== undefined);
      return providedKeys.length === 1;
    },
    {
      message: 'Only one filter can be used at a time.',
      path: [],
    },
  );

type LicitacionesQueryParams = z.infer<typeof LicitacionesQueryParamsSchema>;

class AgileTenderFullInfoTO{
  @ApiProperty({
    description: 'General information of agile tender',
    type: AgileTenderTO,
    required: true,
  })
  general: AgileTenderTO;
  @ApiProperty({
    description: 'Detail of agile tender',
    type: DetailAgileTenderTO,
    required: false,
  })
  licitacionAgilDetail?: DetailAgileTenderTO | undefined;
}

export {
  Listado as Licitacion,
  AgileTenderTO,
  LicitacionesQueryParams,
  LicitacionesQueryParamsSchema,
  LicitacionesResponse,
  AgileTenderPageResponse,
  MatchWordTO,
  DetailAgileTenderTO,
  ProductoSolicitadoTO,
  EstadoQueryEnum,
  InformacionInstitucionTO,
  AgileTenderDetailResponse,
  AgileTenderFullInfoTO
};
