import { TxType } from "src/framework";
import { Subdivision } from "src/framework/domain/entities/subdivision.entity";
import { Company, CompanyRegisterTO, InsertCompany, MinimalCompany } from "src/licitaapp/domain";
import { CompanyUserTO, PaginationKeywordTO } from "src/licitaapp/domain/dto/company.user.to";
import { KeywordCompanyTO } from "src/licitaapp/domain/dto/keyword-company.to";

export interface CompanyRepository {
  deletedCompanySubdivisions(companyId: number, tx?: TxType): Promise<void> ;
  findByDNI(dni: string, tx?: TxType): Promise<Company | null> ;
  findById(id: number, tx?: TxType): Promise<Company | null>;
  findCompaniesSubdivisions(companyId: number, tx?: TxType): Promise<Subdivision[]>;
  getCompanyIdsToRecalculateTender(): Promise<number[]>;
  // retorna los IDs de las empresas activas
  getCompanyIdsActive(): Promise<number[]>;
  getSubdivisionsByCompanyId(companyId: number): Promise<Subdivision[]>;
  paginationByCompanyAdmin(page: number, pageSize: number): Promise<CompanyUserTO[]>;
  save(company: InsertCompany, tx?: TxType): Promise<Company>;
  saveCompanySubdivisions(companyId: number,listSubdivisions: Subdivision[],tx?: TxType,): Promise<void>;
  update(companyId: number, companyData: CompanyRegisterTO, tx?: TxType): Promise<boolean>;
  updateCheckTenders(companyId: number, checkTender: boolean, tx?: TxType): Promise<boolean>;

  // Obtiene los ids de companias que tiene 1 solo rubro informado.
  getAllCompanyWithoutKeywords(): Promise<number[]>;
  paginationByCompanyKeyword(page: number, pageSize: number, socialReason?: string): Promise<PaginationKeywordTO[]>;
  //TODO: reparar findCompaniesKeywords(keywordIds: number[]): Promise<MinimalCompany[]>;

}