import { AgileTender } from "src/licitaapp/domain";
import { UserHistoryAgileTenderRow } from "src/licitaapp/domain/type/user-history-agile-tender.types";
import { AgileTenderTO } from "../../mercado-publico";

export interface HistoryAgileTenderRepository {
    save(userId: number, tenderAgileId: number): Promise<boolean>;
    erraseUserAgileHistoryTender(tenderInfo: AgileTender): Promise<void>;
    findByUserAgileTender(userId: number, tenderAgileId: number): Promise<UserHistoryAgileTenderRow | undefined>;
    getTenderAgilePaginated(userId: number, page: number, pageSize: number,
        companyId: number, searchType: string
    ): Promise<AgileTenderTO[]>;
    updateFavoriteUserCompanyAgileTender(userId: number, companyId: number, agileTenderId: number, isFavorite: boolean): Promise<void>;
}
