import { TxType } from "src/framework";
import { InsertKeyword, Keyword, Metadata, UpdateKeyword } from "src/licitaapp/domain";

export interface KeywordRepository {

  
  logicalRemove(id: number, tx?: TxType): Promise<void>;

  findById(id: number, tx?: TxType): Promise<Keyword | null | undefined>;
  findByCodeCategoriaMercadoPublico(codeCategoriaMercadoPublico: number[], tx?: TxType | undefined): Promise<Keyword[]>;
  //TODO: mover findByCompanyId(companyId: number, isNullMetadata: boolean, tx?: TxType): Promise<Keyword[]>;
  getAllWithouthMetadata(tx?: TxType): Promise<Keyword[]>;

  updateMetadata(keywordId: number, metadata: Metadata): Promise<void>;

  save(keyword: InsertKeyword, tx?: TxType): Promise<Keyword>;
  saveAll(keywords: InsertKeyword[], tx?: TxType): Promise<Keyword[]>;

  //TODO: mover findByCompanyLimitedId(companyId: number, tx?: TxType): Promise<Keyword[]>;
  // deleteByCompanyId(companyId: number, tx?: TxType): Promise<void>;
  findAdminValues(): Promise<string[]>;
  findKeywordsByNameList(names: string[]): Promise<number[]>;
}
