import { TxType } from 'src/framework';
import { InsertMatchingWord, MatchingWord, UpdateMatchingWord } from 'src/licitaapp/domain';

export interface MatchingWordRepository {
  findAll(): Promise<MatchingWord[]>;
  getPagination(page: number, pageSize: number, subdivisionId?: string, wordSearch?: string): Promise<MatchingWord[]>;
  findById(id: number, tx?: TxType): Promise<MatchingWord | null | undefined>;
  save(matchingWord: InsertMatchingWord, tx?: TxType): Promise<boolean>;
  update(
    matchingWord: UpdateMatchingWord,
    tx?: TxType
  ): Promise<boolean>;
  delete(matchingWordId: number, tx?: TxType): Promise<boolean>;
  mapRowToEntity(rowRecord: any): MatchingWord;
}
