import { InsertTenderKeywordCategory, TenderKeywordCategory } from "src/licitaapp/domain/entities/tender-keyword-category.entity";

export interface TenderKeywordCategoryRepository {
    upsert(tender: InsertTenderKeywordCategory): Promise<number>;
    errase(tenderKeywordCategoryId: number): Promise<void>;
    findAllByCodeMercadoPublico(codeMercadoPublico: number[], returnNormalTender: boolean): Promise<number[]>;
    // busqueda simple y directa a las categorias de las licitaciones
    findAllByWordFilter(wordFilter: string, returnNormalTender: boolean): Promise<number[]>;
    findAllByNormaltenderId(normalTenderId: number): Promise<TenderKeywordCategory[]>;
    findAllByAgileTenderId(agileTenderId: number): Promise<TenderKeywordCategory[]>;
    saveNormalTenderCategory(tenderId: number, codeMercadoPublico: string, itemDescription: string): Promise<void>;
    saveAgileTenderCategory(tenderId: number, codeMercadoPublico: string, itemDescription: string): Promise<void>;
}
