import { Subdivision } from "src/framework/domain/entities/subdivision.entity";
import { Company, CompanyFullTO, CompanyRegisterTO, MinimalCompany } from "src/licitaapp/domain";
import { CompanyKeywordPaginationTO } from "src/licitaapp/domain/dto/company.keyword.pagination.to";

import { CompanyUserTO, PaginationKeywordTO } from "src/licitaapp/domain/dto/company.user.to";
import { KeywordCompanyTO } from "src/licitaapp/domain/dto/keyword-company.to";
import { UserPaginationTO } from "src/licitaapp/domain/dto/user.pagination.to";

export interface CompanyService {
    createCompany(userId: number, insertCompany: CompanyRegisterTO): Promise<CompanyFullTO | null>;
    findByDNI(dni: string): Promise<Company | null>;
    findById(id: number): Promise<Company | null>;
    findByIdWithFetch(id: number): Promise<CompanyFullTO | null>;
    getCompanyIdsToRecalculateTender(): Promise<number[]>;
    getSubdivisionsByCompanyId(companyId: number): Promise<Subdivision[]>;
    // retorna los IDs de las empresas activas
    getCompanyIdsActive(): Promise<number[]>;
    paginationByCompanyAdmin(page: number, pageSize: number): Promise<UserPaginationTO>;
    updateCheckTenders(companyId: number, checkTender: boolean): Promise<boolean>;
    updateCompany(companyId: number, userId: number, updateCompany: CompanyRegisterTO): Promise<CompanyFullTO | null>;

    // Obtiene los ids de companias que tiene 1 solo rubro informado.
    getAllCompanyWithoutKeywords(): Promise<number[]>;
    // paginacion de empresas y lista de sus keyword
    paginationByCompanyKeyword(page: number, pageSize: number, socialReason?: string): Promise<PaginationKeywordTO[]>;
    // en base a una lista de keywords, obtiene las empresas que las contienen
    //TODO: reparar findCompaniesKeywords(KeywordCompanyTO: KeywordCompanyTO): Promise<MinimalCompany[]>;
}
