import { TxType } from "src/framework";
import { InsertKeyword, Keyword, KeywordItem, Metadata } from "src/licitaapp/domain";

export interface KeywordService {
    logicalRemove(keywordsId: number): Promise<void>;

    findByName(search: string): Promise<KeywordItem[]>;
    getAllWithouthMetadata(tx?: TxType): Promise<Keyword[]>;

    save(keyword: InsertKeyword, tx?: TxType): Promise<Keyword>;
    saveAll(keywords: InsertKeyword[], tx?: TxType): Promise<Keyword[]>;

    updateMetadata(keywordId: number, metadata: Metadata): Promise<void>;

    findAdminValues(): Promise<string[]>;
    findKeywordsByNameList(names: string[]): Promise<number[]>;

    findByCodeCategoriaMercadoPublico(codeCategoriaMercadoPublico: number[], tx?: TxType | undefined): Promise<Keyword[]>;
}
