import { ApplicationTypeEnum } from "src/licitaapp/domain/enum/enum.definition";
import { LicitacionesQueryParams, LicitacionesResponse } from "../../mercado-publico";

export interface TenderFetcherService {
    fetchTendersWithRetry(args: LicitacionesQueryParams): Promise<LicitacionesResponse | undefined>;
    processTenders(args: LicitacionesQueryParams): Promise<boolean>;
    /**
     * Rescata las licitaciones del día actual desde el servicio de Mercado Público.
     */
    fetchTendersOfTheDay(ddmmyyyy?:string): Promise<boolean | undefined>;
    /**
     * Rescata licitaciones pasadas en base a TENDERS_LIMIT_DAYS desde el servicio Mercado Público.
     */
    syncTenders(): Promise<void>;
    

    // ejecuta una accion con log y manejo de errores
    logAndExecute(type: ApplicationTypeEnum, applicationLogId:number, action: (applicationLogId:number) => Promise<string>): Promise<void>;
    // busca licitaciones normales del dia
    callfetchTendersOfTheDay(applicationLogId: number): Promise<string>;
    callFetchAgileTenders(applicationLogId: number): Promise<string>;
    // une licitaciones agiles con palabras clave a las empresas que las siguen
    joinAgileTenderWithKeywords(applicationLogId: number, companyId?: number, userId?: number): Promise<string>;

}
