import { AgileTender } from 'src/licitaapp/domain';
import { AgileTenderFullInfoTO, AgileTenderTO } from '../../mercado-publico';
import { UserRequestService } from 'src/framework';

export interface UserCompanyAgileTenderService {
  erraseUserCompanyAgileTender(tenderAgileIds: number[]): Promise<void>;
  saveAll(
    userId: number,
    companyId: number,
    tenderIds: number[],
    isFavorite: boolean,
    agileCode?: string,
    userRequestService?: UserRequestService,
  ): Promise<boolean>;
  getPaginatedAgileTenders(
    userId: number,
    companyId: number,
    page: number,
    pageSize: number,
    isFavorite: boolean
  ): Promise<AgileTenderFullInfoTO[]>;
  // listado de favoritos tender agile
  getFavoriteList(userId: number): Promise<number[]>;
  countActiveTendersCompany(companyId: number): Promise<number>;
  findTenderByUserCompanyId(
    userId: number,
    companyId: number
  ): Promise<AgileTender[]>;
}
