import { ApiProperty, ApiPropertyOptional, OmitType } from '@nestjs/swagger';
import { UserMinimalTO } from './user.minimal.to';
import { Keyword } from '../entities';

class CompanyUserBaseTO {
    
    @ApiProperty({
        description: 'Company id',
        example: 16,
        type: Number,
        required: true,
    })
    public companyId: number;
    @ApiProperty({
        description: 'Company name',
        example: 'Example Company',
        type: String,
        required: true,
    })
    public socialReason: string;
    @ApiPropertyOptional({
        description: 'Company fields user',
        type: String,
        required: true,
    })
    public dni: string;
    @ApiProperty({
        description: 'Company active status',
        example: true,
        type: Boolean,
        required: true,
    })
    public active: boolean;
    @ApiProperty({
        description: 'Company fields user',
        example: 15,
        type: Number,
        required: true,
    })
    public amountTenders: number;
    @ApiProperty({
        description: 'Users',
        type:() => [UserMinimalTO],
        required: true,
    })
    public listUsers: UserMinimalTO[];
    @ApiProperty({
        description: 'Company fields user',
        example: 15,
        type: Number,
        required: true,
    })
    public amountAgileTenders: number;
    @ApiProperty({
        description: 'Keywords',
        type:() => [Keyword],
        required: true,
    })
    public listKeywords: Keyword[];

}

class PaginationKeywordTO extends OmitType(CompanyUserBaseTO, ['listUsers']) {}
class CompanyUserTO extends OmitType(CompanyUserBaseTO, ['listKeywords', 'amountAgileTenders']) {};

export { CompanyUserTO, PaginationKeywordTO };