import { ApiProperty } from "@nestjs/swagger";
import { DashboardDetailTO } from "./dashboard.detail.to";
import { AgileDashboardTO } from "./agile-dashboard.to";

export class DashboardTO {
    
    @ApiProperty({
        description: 'Tender total amount',
        example: 1545,
    })
    tenderTotalAmount: number;
    
    @ApiProperty({
        description: 'new tenders amount',
        example: 16,
    })
    newTenderAmount: number;

    @ApiProperty({
        description: 'User amount sharing company',
        example: 16,
    })
    userAmount: number;
    
    @ApiProperty({
        description: 'tenders dashboard details',
        example: '15 UF, 20 UTM, $30 m',
        type: [DashboardDetailTO],
    })
    listDetails: DashboardDetailTO[];  

    @ApiProperty({
        description: 'Agile tenders detail',
        type: AgileDashboardTO,
    })
    agileTendersDetail: AgileDashboardTO;
}