import { ApiProperty } from '@nestjs/swagger';


class PaginationNormalTenderTO {
  @ApiProperty({
    description: 'Tender id',
    example: 1,
    type: Number,
    required: true,
  })
  id: number;

  @ApiProperty({
    description: 'Tender code',
    example: '1111-111-A111',
    type: String,
    required: true,
  })
  code: string;

  @ApiProperty({
    description: 'Tender name',
    example: 'School supplies',
    type: String,
    required: true,
  })
  name: string;

  @ApiProperty({
    description: 'Tender description',
    example: 'School supplies for the next school year',
    type: String,
    required: true,
  })
  description: string;

  @ApiProperty({
    description: 'Subdivision id',
    type: Number,
    example: 2,
    required: false,
  })
  subdivisionId?: number | null;

  @ApiProperty({
    description: 'Subdivision label',
    example: 'Education',
    type: String,
    required: false,
  })
  subdivisionLabel?: string | null;

  @ApiProperty({
    description: 'Update date',
    example: '1991-01-01T00:00:00.000Z',
    type: Date,
    required: false,
  })
  closeDate?: Date | null | undefined;

}


export { PaginationNormalTenderTO };

