import { ApiProperty } from '@nestjs/swagger';
import { Licitacion } from '../type';

export class TenderHistoryTO {
  @ApiProperty({
    description: 'tender id',
    example: 1545,
    required: true,
  })
  tenderId: number;

  @ApiProperty({
    description: 'Tender code',
    example: '1111-111-A111',
  })
  code: string;

  @ApiProperty({
    description: 'Tender name',
    example: 'School supplies',
  })
  name: string;

  @ApiProperty({
    description: 'Tender description',
    example: 'School supplies for the next school year',
  })
  description: string;

  @ApiProperty({
    description: 'Tender details',
  })
  details: Licitacion;

  @ApiProperty({
    description: 'Creation date',
    example: '1991-01-01T00:00:00.000Z',
    required: false,
  })
  createdAt: Date;

  @ApiProperty({
    description: 'Last update date',
    example: '1991-01-01T00:00:00.000Z',
    required: false,
  })
  updatedAt?: Date | null;
}
