import { ApiProperty, OmitType, PartialType } from '@nestjs/swagger';
import { Metadata } from './metadata.to';
import { KeywordOrigin } from './keyword.entity';

class AgileKeyword {
  @ApiProperty({
    description: 'Keyword id',
    example: 1,
  })
  id: number;

  @ApiProperty({
    description: 'Keyword name',
    example: 'Venta',
    required: false,
  })
  value: string;

  @ApiProperty({
    description: 'Company id',
    example: 1,
    required: true,
  })
  agileTenderId?: number | null | undefined;

  @ApiProperty({
    description: 'User id',
    example: 1,
    required: false,
  })
  userId?: number;

  @ApiProperty({
    description: 'Keyword origin',
    enum: KeywordOrigin,
    enumName: 'KeywordOrigin',
  })
  origin?: KeywordOrigin;
 
  @ApiProperty({
    description: 'Metadata',
    required: false,
  })
  metadata:Metadata | null | undefined;

  constructor(
    id: number,
    value: string,
    origin?: KeywordOrigin,
    isSelected?: boolean,
    agileTenderId?: number | null | undefined,
    metadata?: Metadata | null | undefined,
  ) {
    this.id = id;
    this.value = value;
    this.origin = origin;
    this.agileTenderId = agileTenderId;
    this.metadata = metadata;
  }
}

class InsertAgileKeyword extends OmitType(AgileKeyword, ['id']) {}

class UpdateAgileKeyword extends PartialType(InsertAgileKeyword) {}

class AgileKeywordItem extends OmitType(AgileKeyword, ['id', 'metadata']) {}

export {
  InsertAgileKeyword,
  AgileKeyword,
  AgileKeywordItem,
  KeywordOrigin,
  UpdateAgileKeyword
};

