import { ApiProperty, OmitType } from '@nestjs/swagger';
import { AgileTenderFullInfoTO } from 'src/licitaapp/application';


class AgileTender {
  @ApiProperty({
    description: 'Tender id',
    example: 1,
  })
  id: number;

  @ApiProperty({
    description: 'Tender code',
    example: '1111-111-A111',
  })
  code: string;

  @ApiProperty({
    description: 'Tender name',
    example: 'School supplies',
  })
  name: string;

  @ApiProperty({
    description: 'Tender description',
    example: 'School supplies for the next school year',
  })
  description: string;

  @ApiProperty({
    description: 'Tender description location',
    example: 'Municipality of Santiago',
  })
  descriptionLocation: string;

  @ApiProperty({
    description: 'Tender details',
    type: AgileTenderFullInfoTO
  })
  details: AgileTenderFullInfoTO;
  
  @ApiProperty({
    description: 'Creation date',
    example: '1991-01-01T00:00:00.000Z',
    required: false,
  })
  createdAt: Date;

  @ApiProperty({
    description: 'Update date',
    example: '1991-01-01T00:00:00.000Z',
    required: false,
  })
  updatedAt?: Date | null | undefined;

  @ApiProperty({
    description: 'Tender isFavorite',
    example: true,
  })
  isFavorite: boolean;

  @ApiProperty({
    description: 'Close date',
    example: '1991-01-01T00:00:00.000Z',
    required: true,
  })
  closeDate: Date;

  @ApiProperty({
    description: 'amount clp',
    example: 1545,
    type: Number,
    required: true,
  })
  amountCLP: number;    

  @ApiProperty({
    description: 'Subdivision id',
    example: 19,
    type: Number,
    required: false,
  })
  subdivisionId?: number | null;
  

  constructor(
    id: number,
    code: string,
    name: string,
    description: string,
    details: AgileTenderFullInfoTO,
    createdAt: Date,
    closeDate: Date,
    isFavorite: boolean,
    descriptionLocation: string,
    amountCLP: number,
    updatedAt?: Date | null,
    subdivisionId?: number | null,
  ) {
    this.descriptionLocation = descriptionLocation;
    this.code = code;
    this.name = name;
    this.updatedAt = updatedAt;
    this.closeDate = closeDate;
    this.description = description;
    this.id = id;
    this.details = details;
    this.createdAt = createdAt;
    this.isFavorite = isFavorite;
    this.subdivisionId = subdivisionId;
    this.amountCLP = amountCLP;
  }
}

class InsertAgileTender extends OmitType(AgileTender, ['id']) {}

class MinimalToEditAgileTender extends OmitType(AgileTender, [
  'code',
  'name',
  'createdAt',
  'updatedAt',
  'isFavorite',
  'closeDate',
  'amountCLP',
]) {}

class UpdateMinimalToEditAgileTender extends OmitType(AgileTender, [
  'code',
  'name',
  'createdAt',
  'updatedAt',
  'isFavorite',
  'closeDate',
  'amountCLP',
  'details',
  'descriptionLocation'
]) {}

export { InsertAgileTender, AgileTender, MinimalToEditAgileTender, UpdateMinimalToEditAgileTender };

