import { ApiProperty, OmitType, PartialType } from '@nestjs/swagger';
import { Metadata } from './metadata.to';


enum KeywordOrigin {
  USER = 'USER',
  MERCADO_PUBLICO = 'MERCADO_PUBLICO',
  ADMIN = 'ADMIN',
}

class Keyword {
  @ApiProperty({
    description: 'Keyword id',
    example: 1,
  })
  id: number;

  @ApiProperty({
    description: 'Keyword name',
    example: 'Venta',
    required: false,
  })
  value: string;

  @ApiProperty({
    description: 'Code Categoria Mercado Publico',
    example: 123,
    type: Number,
    required: true,
  })
  codeCategoriaMercadoPublico: number;

  @ApiProperty({
    description: 'Keyword origin',
    enum: KeywordOrigin,
    enumName: 'KeywordOrigin',
  })
  origin?: KeywordOrigin;

  @ApiProperty({
    description: 'State bool for favorites section',
    example: true,
    required: false,
  })
  isSelected?: boolean;

  @ApiProperty({
    description: 'Metadata',
    required: false,
  })
  metadata:Metadata | null | undefined;

  constructor(
    id: number,
    value: string,
    codeCategoriaMercadoPublico: number,
    origin?: KeywordOrigin,
    isSelected?: boolean,
    metadata?: Metadata | null | undefined,
  ) {
    this.id = id;
    this.value = value;
    this.origin = origin;
    this.codeCategoriaMercadoPublico = codeCategoriaMercadoPublico;
    this.isSelected = isSelected;
    this.metadata = metadata;
  }
}

class InsertKeyword extends OmitType(Keyword, ['id', 'isSelected']) {}

class AddCompanyKeyword extends OmitType(Keyword, [
  'id',
  'isSelected',
  'metadata',
]) {}

class UpdateKeyword extends PartialType(InsertKeyword) {}

class KeywordItem extends OmitType(Keyword, ['id', 'metadata']) {}

export {
  AddCompanyKeyword,
  InsertKeyword,
  Keyword,
  KeywordItem,
  KeywordOrigin,
  UpdateKeyword
};

