import { ApiProperty, OmitType } from '@nestjs/swagger';
import { MatchWordTO } from 'src/licitaapp/application';
import { Subdivision } from 'src/framework/domain/entities/subdivision.entity';

class MatchingWord {

  @ApiProperty({
    description: 'Keyword id',
    example: 1,
  })
  id: number;

  @ApiProperty({
    description: 'Keyword name',
    required: true,
  })
  coincidence: MatchWordTO;

  @ApiProperty({
    description: 'User id',
    type: () => Subdivision,
  })
  subdivision: Subdivision | null | undefined;

  @ApiProperty({
    description: 'Subdivision id',
    example: 1,
    type: Number,
    required: false,
  })
  subdivisionId?: number | null | undefined;

  constructor(
    id: number,
    coincidence: MatchWordTO,
    subdivision: Subdivision | null | undefined,
    subdivisionId?: number | null | undefined,
  ) {
    this.id = id;
    this.coincidence = coincidence;
    this.subdivision = subdivision;
    this.subdivisionId = subdivisionId;
  }
}

class InsertMatchingWord extends OmitType(MatchingWord, ['id', 'subdivision']) {}
class UpdateMatchingWord extends OmitType(MatchingWord, ['subdivision']) {}

export {
  MatchingWord,
  InsertMatchingWord,
  UpdateMatchingWord,
};

