
class Word {
    position: number;
    startingPos: number;
    endingPos: number;
    stem: string;
    token: string;
    partOfSpeech: string;
    constructor(position: number, startingPos: number, endingPos: number, stem: string, token: string, partOfSpeech: string){
        this.position = position;
        this.startingPos = startingPos;
        this.endingPos = endingPos;
        this.stem = stem;
        this.token = token;
        this.partOfSpeech = partOfSpeech;
    }
}

class CoarseTopics {
    label: string;
    score: number;
    constructor(label: string, score: number){
        this.label = label;
        this.score = score;
    }
}

class Topics {
    label: string;
    score: number;
    constructor(label: string, score: number){
        this.label = label;
        this.score = score;
    }    
}

class EntityInfo{
    entityId: string;
    type: string[];
    confidenceScore: number;
    constructor(entityId: string, type: string[], confidenceScore: number){
        this.entityId = entityId;
        this.type = type;
        this.confidenceScore = confidenceScore;
    }
}

class Metadata {
    coarseTopics: any[];
    topics: any[];
    entities: any[];
    words: any[];
}

class HistoryMetadata {
    labelAmount: string;
    labelLastUpdated: string;
    labelCloseTender: string;
    typeOfMoney: string;
    description: string;
    name: string;
}

export { Metadata, Word, CoarseTopics, Topics, EntityInfo, HistoryMetadata };