import { ApiProperty, OmitType } from '@nestjs/swagger';

class TenderKeywordCategory {
  @ApiProperty({
    description: 'Tender id',
    example: 1,
  })
  id: number;

  @ApiProperty({
    description: 'Code Mercado Publico',
    example: 19,
    type: Number,
    required: true,
  })
  codeMercadoPublico: number;

  @ApiProperty({
    description: 'Item Description',
    example: 'Construcción de obras civiles',
    type: String,
    required: true,
  })
  itemDescription: string;

  @ApiProperty({
    description: 'Agile Tender id',
    example: 19,
    type: Number,
    required: false,
  })
  agileTenderId?: number | null;

  @ApiProperty({
    description: 'Normal Tender id',
    example: 19,
    type: Number,
    required: false,
  })
  normalTenderId?: number | null; 

  constructor(
    id: number,
    codeMercadoPublico: number,
    itemDescription: string,
    agileTenderId?: number | null,
    normalTenderId?: number | null,
  ) {
    this.id = id;
    this.itemDescription = itemDescription;
    this.codeMercadoPublico = codeMercadoPublico;
    this.agileTenderId = agileTenderId;
    this.normalTenderId = normalTenderId;
  }
}

class InsertTenderKeywordCategory extends OmitType(TenderKeywordCategory, ['id']) {}

export { InsertTenderKeywordCategory, TenderKeywordCategory};