import { ApiProperty, OmitType, PartialType } from '@nestjs/swagger';
import { Metadata } from './metadata.to';
import { Licitacion } from '../type';


class Tender {
  @ApiProperty({
    description: 'Tender id',
    example: 1,
  })
  id: number;

  @ApiProperty({
    description: 'Tender code',
    example: '1111-111-A111',
  })
  code: string;

  @ApiProperty({
    description: 'Tender name',
    example: 'School supplies',
  })
  name: string;

  @ApiProperty({
    description: 'Tender description',
    example: 'School supplies for the next school year',
  })
  description: string;

  @ApiProperty({
    description: 'Tender details',
  })
  details: Licitacion;

  @ApiProperty({
    description: 'Price',
    example: '15M CLP',
  })
  labelAmount: string;

  @ApiProperty({
    description: 'Type of money',
    example: 'CLP',
  })
  typeOfMoney: String;

  @ApiProperty({
    description: 'Last updated record',
    example: '1 minute ago',
  })
  labelLastUpdated: String;

  @ApiProperty({
    description: 'Creation date',
    example: '1991-01-01T00:00:00.000Z',
    required: false,
    type: Date,
  })
  createdAt: Date;

  @ApiProperty({
    description: 'Tender isFavorite',
    example: true,
    type: Boolean,
  })
  isFavorite: boolean;

  @ApiProperty({
    description: 'Last update date',
    example: '1991-01-01T00:00:00.000Z',
    required: false,
    type: Date,
  })
  updatedAt?: Date | null;

  @ApiProperty({
    description: 'Close date',
    example: '1991-01-01T00:00:00.000Z',
    required: false,
    type: Date,
  })
  closeDate?: Date | null;

  @ApiProperty({
    description: 'Subdivision id',
    example: '19',
    required: false,
  })
  subdivisionId?: number | null;

  @ApiProperty({
    description: 'Source',
    example: 'GEO',
    required: false,
  })
  source?: string;

  @ApiProperty({
    description: 'Close tender label',
    example: '12 h',
    required: false,
  })
  labelCloseTender?: string;

  @ApiProperty({
    description: 'Metadata',
    required: false,
  })
  metadata?:Metadata | null | undefined;

  @ApiProperty({
    description: 'Match result',
    required: false,
  })
  matchResult?: string | null | undefined;

  @ApiProperty({
    description: 'Tender is errased',
    example: true,
    required: false,
    type: Boolean,
  })
  isErrased?: boolean;

  @ApiProperty({
    description: 'Minimal detail category',
    example: ['Construcción'],
    type: [String],
    required: false,
  })
  minimalDetailCategory?: string[];

  constructor(
    id: number,
    code: string,
    name: string,
    description: string,
    details: Licitacion,
    createdAt: Date,
    updatedAt: Date | null,
    closeDate: Date | null,
    isFavorite: boolean,
    subdivisionId?: number | null,
    source?: string,
    labelCloseTender?: string,
    metadata?: Metadata | null | undefined,
    matchResult?: string | null | undefined,
  ) {
    this.code = code;
    this.name = name;
    this.closeDate = closeDate;
    this.description = description;
    this.id = id;
    this.details = details;
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
    this.subdivisionId = subdivisionId;
    this.source = source;
    this.labelCloseTender = labelCloseTender;
    this.metadata = metadata;
    this.matchResult = matchResult;
    this.isFavorite = isFavorite;
  }
}

class InsertTender extends OmitType(Tender, ['id','isErrased', 'minimalDetailCategory', 'labelAmount', 'typeOfMoney', 'labelLastUpdated', 'createdAt', 'updatedAt', 'labelCloseTender', 'matchResult']) {}

class RequestTender extends OmitType(Tender, ['details', 'createdAt', 'updatedAt', 'minimalDetailCategory']) {}

class UpdateTender extends PartialType(Tender) {}

class HistoryTenderDetail extends OmitType(Tender, ['subdivisionId', 'metadata', 'minimalDetailCategory','source', 'matchResult', 'closeDate', 'details', 'isFavorite', 'createdAt', 'updatedAt']) {}

export { InsertTender, Tender, UpdateTender, RequestTender, HistoryTenderDetail };

