import { z } from 'zod';
interface Comprador {
  CodigoOrganismo: string;
  NombreOrganismo: string;
  RutUnidad: string;
  CodigoUnidad: string;
  NombreUnidad: string;
  DireccionUnidad: string;
  ComunaUnidad: string;
  RegionUnidad: string;
  RutUsuario: string;
  CodigoUsuario: string;
  NombreUsuario: string;
  CargoUsuario: string;
}

interface Fechas {
  FechaCreacion: string;
  FechaCierre: string | undefined;
  FechaInicio: string;
  FechaFinal: string;
  FechaPubRespuestas: string;
  FechaActoAperturaTecnica: string;
  FechaActoAperturaEconomica: string;
  FechaPublicacion: string;
  FechaAdjudicacion: string;
  FechaEstimadaAdjudicacion: string;
  FechaSoporteFisico: string | undefined;
  FechaTiempoEvaluacion: string | undefined;
  FechaEstimadaFirma: string;
  FechasUsuario: string | undefined;
  FechaVisitaTerreno: string | undefined;
  FechaEntregaAntecedentes: string | undefined;
}

enum AdjudicacionTipoEnum {
  AUTORIZACION = 1,
  RESOLUCION = 2,
  ACUERDO = 3,
  DECRETO = 4,
  OTROS = 5,
}

interface Adjudicacion {
  Tipo: AdjudicacionTipoEnum | undefined;
  Fecha: string | undefined;
  Numero: string | undefined;
  NumeroOferentes: number;
  UrlActa: string;
}

interface Item {
  Correlativo: number;
  CodigoProducto: number;
  CodigoCategoria: string;
  Categoria: string;
  NombreProducto: string;
  Descripcion: string;
  UnidadMedida: string;
  Cantidad: number;
  Adjudicacion: string | undefined;
}

interface Items {
  Cantidad: number;
  Listado: Item[];
}

enum MonedaEnum {
  CLP = 'CLP',
  CLF = 'CLF',
  USD = 'USD',
  UTM = 'UTM',
  EUR = 'EUR',
}

enum ModalidadPagoEnum {
  PAGO_30_DIAS = 1,
  PAGO_30_60_90_DIAS = 2,
  PAGO_AL_DIA = 3,
  PAGO_ANUAL = 4,
  PAGO_BIMENSUAL = 5,
  PAGO_CONTRA_ENTREGA_CONFORME = 6,
  PAGOS_MENSUALES = 7,
  PAGO_POR_ESTADO_DE_AVANCE = 8,
  PAGO_TRIMESTRAL = 9,
  PAGO_60_DIAS = 10,
}

enum UnidadTiempoEnum {
  HORAS = 1,
  DIAS = 2,
  SEMANAS = 3,
  MESES = 4,
  ANOS = 5,
}

enum TipoEnum {
  L1 = 'L1',
  LE = 'LE',
  LP = 'LP',
  LQ = 'LQ',
  LR = 'LR',
  E2 = 'E2',
  CO = 'CO',
  B2 = 'B2',
  H2 = 'H2',
  I2 = 'I2',
  LS = 'LS',
}

interface Listado {
  CodigoExterno: string;
  Nombre: string;
  CodigoEstado: number;
  Descripcion: string;
  FechaCierre: string | undefined;
  Estado: string;
  Comprador: Comprador;
  DiasCierreLicitacion: string;
  Informada: boolean;
  CodigoTipo: number;
  Tipo: TipoEnum;
  TipoConvocatoria: number;
  Moneda: MonedaEnum;
  Etapas: number;
  EstadoEtapas: string;
  TomaRazon: number;
  EstadoPublicidadOfertas: number;
  JustificacionPublicidad: string;
  Contrato: number;
  Obras: number;
  CantidadReclamos: number;
  Fechas: Fechas;
  UnidadTiempoEvaluacion: UnidadTiempoEnum;
  DireccionVisita: string;
  DireccionEntrega: string;
  Estimacion: number;
  FuenteFinanciamiento: string;
  VisibilidadMonto: boolean;
  MontoEstimado: number | undefined;
  Tiempo: string | undefined;
  UnidadTiempo: UnidadTiempoEnum;
  Modalidad: ModalidadPagoEnum;
  TipoPago: string;
  NombreResponsablePago: string;
  EmailResponsablePago: string;
  NombreResponsableContrato: string;
  EmailResponsableContrato: string;
  FonoResponsableContrato: string;
  ProhibicionContratacion: string;
  SubContratacion: boolean;
  UnidadTiempoDuracionContrato: number;
  TiempoDuracionContrato: string;
  TipoDuracionContrato: string;
  JustificacionMontoEstimado: string | undefined;
  ObservacionContract: string | undefined;
  ExtensionPlazo: boolean;
  EsBaseTipo: boolean;
  UnidadTiempoContratoLicitacion: string;
  ValorTiempoRenovacion: string;
  PeriodoTiempoRenovacion: string;
  EsRenovable: boolean;
  Adjudicacion: Adjudicacion;
  Items: Items;
}

class LicitacionesResponse {
  Cantidad: number;
  FechaCreacion: string;
  Version: string;
  Listado: Listado[];

  static fromJson(data: LicitacionesResponse): LicitacionesResponse {
    data.Listado = data.Listado.map((item) => {
      item.Informada = (item.Informada as unknown as number) === 1;
      item.VisibilidadMonto =
        (item.VisibilidadMonto as unknown as number) === 1;
      item.SubContratacion = (item.SubContratacion as unknown as number) === 1;
      item.ExtensionPlazo = (item.ExtensionPlazo as unknown as number) === 1;
      item.EsBaseTipo = (item.EsBaseTipo as unknown as number) === 1;
      item.EsRenovable = (item.EsRenovable as unknown as number) === 1;
      return item;
    });
    return data;
  }
}

enum EstadoQueryEnum {
  PUBLICADA = 'Publicada',
  CERRADA = 'Cerrada',
  DESIERTA = 'Desierta',
  ADJUDICADA = 'Adjudicada',
  REVOCADA = 'Revocada',
  SUSPENDIDA = 'Suspendida',
  ACTIVAS = 'activas',
}

const LicitacionesQueryParamsSchema = z
  .object({
    codigo: z.string().optional(),
    fecha: z.string().optional(),
    estado: z.nativeEnum(EstadoQueryEnum).optional(),
    CodigoOrganismo: z.string().optional(),
    CodigoProveedor: z.string().optional(),
  })
  .refine(
    (data) => {
      const keys: (keyof typeof data)[] = [
        'codigo',
        'fecha',
        'estado',
        'CodigoOrganismo',
        'CodigoProveedor',
      ];
      const providedKeys = keys.filter((key) => data[key] !== undefined);
      return providedKeys.length === 1;
    },
    {
      message: 'Only one filter can be used at a time.',
      path: [],
    },
  );

type LicitacionesQueryParams = z.infer<typeof LicitacionesQueryParamsSchema>;

export {
  Listado as Licitacion,
  LicitacionesQueryParams,
  LicitacionesQueryParamsSchema,
  LicitacionesResponse,
};
