import { Controller, Get, Inject, Param, Post, Put } from '@nestjs/common';
import {
  ApiOkResponse,
  ApiOperation,
  ApiParam,
  ApiTags,
} from '@nestjs/swagger';
import { PrimeLogger } from 'src/framework';
import {
  AllowRoles,
  RoleShortNameEnum,
} from 'src/framework/infrastructure/decorators/allow-profiles/allow-roles.decorator';
import { ApiDefaultResponses } from 'src/framework/infrastructure/decorators/api-default-responses/api-default-responses.decorator';
import { UserCompanyService } from 'src/licitaapp/application';
import { TenderService } from 'src/licitaapp/application/service/tender-service/tender-service.interface';
import { GeneralDataInfoTO } from 'src/licitaapp/domain';

@Controller('general-action-tender')
@ApiTags('general-action-tender')
export class GeneralActionTenderController {
  private readonly LOGGER = new PrimeLogger(GeneralActionTenderController.name);
  constructor(
    @Inject('TenderService') private readonly tenderService: TenderService,
    @Inject('UserCompanyService')
    private readonly userCompanyService: UserCompanyService,
  ) {}

  @Put(':companyId')
  @ApiDefaultResponses()
  @ApiOperation({
    summary:
      'En base a un ID de empresa, regenera para todos sus usuarios el dashboard (Union de licitaciones a usuario.).',
  })
  @ApiOkResponse({
    description: 'Gatilla el proceso de dashboard empresa',
    type: () => String,
  })
  @ApiParam({ name: 'companyId', type: 'number' })
  async update(@Param('companyId') companyId: number): Promise<String> {
    this.LOGGER.warn(`Updating company ${companyId} dashboard`);
    const infoUsers =
      await this.userCompanyService.getInfoUserCompany(companyId);
    this.tenderService.createDashboardCompany(
      companyId,
      infoUsers.map((i) => i.userId),
    );
    return 'Generación solicitada correctamente';
  }

  @Post('send-notification-admin')
  @ApiDefaultResponses()
  @AllowRoles(RoleShortNameEnum.USER, RoleShortNameEnum.ADMIN)
  async sendNotificationAdmin() {
    this.LOGGER.warn(`sendNotificationAdmin`);
    this.tenderService.getFirebaseService().notifyToAdminUsers(0);
  }

  @Get('general-info-data')
  @ApiDefaultResponses()
  @AllowRoles(RoleShortNameEnum.USER, RoleShortNameEnum.ADMIN)
  @ApiOkResponse({ type: GeneralDataInfoTO })
  async generalInfoData(): Promise<GeneralDataInfoTO> {
    this.LOGGER.warn(`generalInfoData`);
    return await this.tenderService.createGeneralDataQuery();
  }
}
