import { Controller, Get, Inject, Param, Put } from '@nestjs/common';
import { ApiOkResponse, ApiParam, ApiTags } from '@nestjs/swagger';
import { PrimeLogger } from 'src/framework';
import {
  AllowRoles,
  RoleShortNameEnum,
} from 'src/framework/infrastructure/decorators/allow-profiles/allow-roles.decorator';
import { ApiDefaultResponses } from 'src/framework/infrastructure/decorators/api-default-responses/api-default-responses.decorator';
import { TenderFetcherService } from 'src/licitaapp/application/service/tender-fetcher-service/tender-fetcher-service.interface';
import { TenderService } from 'src/licitaapp/application/service/tender-service/tender-service.interface';
import { ApplicationTypeEnum } from 'src/licitaapp/domain/enum/enum.definition';

@ApiTags('mercado-publico')
@Controller('mercado-publico')
export class MercadoPublicoController {
  private readonly LOGGER = new PrimeLogger(MercadoPublicoController.name);
  constructor(
    @Inject('TenderFetcherService')
    private readonly tenderFetcherService: TenderFetcherService,
    @Inject('TenderService')
    private readonly tenderService: TenderService,
  ) {}

  @Get('search-and-update-tenders/:ddmmyyyy')
  @ApiDefaultResponses()
  @AllowRoles(RoleShortNameEnum.USER, RoleShortNameEnum.ADMIN)
  @ApiOkResponse({ type: String })
  @ApiParam({ name: 'ddmmyyyy', type: 'string', required: true })
  async searchAndUpdateTenders(@Param('ddmmyyyy') ddmmyyyy: string): Promise<String> {
    this.LOGGER.log(`SearchAndUpdateTenders`);
    this.tenderFetcherService.fetchTendersOfTheDay(ddmmyyyy);
    return 'true';
  }

  /*@Get('update-tender-metadata')
  @ApiDefaultResponses()
  @AllowRoles(RoleShortNameEnum.USER, RoleShortNameEnum.ADMIN)
  @ApiOkResponse({ type: String })
  async getTenderMetadata(): Promise<String> {
    this.LOGGER.log(`GetTenderMetadata`);
    this.tenderService.reviewTendersInfo(ApplicationTypeEnum.TENDER_WITHOUT_META_LOG);
    return 'true';
  }*/

  @Put('errase-old-tenders')
  @ApiDefaultResponses()
  @AllowRoles(RoleShortNameEnum.USER, RoleShortNameEnum.ADMIN)
  @ApiOkResponse({ type: String })
  async erraseOldTenders(): Promise<String> {
    this.LOGGER.log(`ErraseOldTenders`);
    this.tenderService.reviewTendersInfo(ApplicationTypeEnum.ERRASE_OLD_TENDERS_LOG);
    return 'true';
  }
}
