import { forwardRef, Module } from '@nestjs/common';
import { DrizzleModule } from 'src/framework';
import { CompanyController } from '../../controllers';
import { CompanyServiceImpl } from '../../service';
import { CompanyRepositoryImpl } from '../../repository';
import { UserCompanyServiceImpl } from '../../service/user-company-service-impl/user-company-service-impl';
import { UserCompanyRepositoryImpl } from '../../repository/user-company-repository-impl/user-company-repository-impl';
import { KeywordModule } from '../keyword/keyword.module';
import { UserCompanyTenderModule } from '../user-company-tender/user-company-tender.module';
import { FwkCacheModule } from 'src/framework/infrastructure/module/fwk-cache/fwk-cache.module';
import { UserCompanyAgileTenderModule } from '../user-company-agile-tender/user-company-agile-tender.module';

@Module({
  imports: [forwardRef(() => DrizzleModule), KeywordModule, FwkCacheModule, UserCompanyTenderModule, UserCompanyAgileTenderModule],
  controllers: [],
  providers: [
    {
      provide: 'UserCompanyService',
      useClass: UserCompanyServiceImpl,
    },
    {
      provide: 'UserCompanyRepository',
      useClass: UserCompanyRepositoryImpl,
    },
    {
      provide: 'CompanyService',
      useClass: CompanyServiceImpl,
    },
    {
      provide: 'CompanyRepository',
      useClass: CompanyRepositoryImpl,
    },
  ],
  exports: [
    'UserCompanyService',
    'UserCompanyRepository',
    'CompanyService',
    'CompanyRepository',
  ],
})
export class CompanyModule {}
