import { forwardRef, Module } from '@nestjs/common';
import { DrizzleModule } from 'src/framework';
import { MercadoPublicoGirosModule } from 'src/licitaapp/application/mercado-publico/mp-giros/mp-giros.module';
import { KeywordController } from '../../controllers/keyword/keyword.controller';
import { KeywordServiceImpl } from '../../service/keyword-service-impl/keyword-service-impl';
import { KeywordRepositoryImpl } from '../../repository/keyword-repository-impl/keyword-repository-impl';
import { CompanyModule } from '../company/company.module';
import { CompanyKeywordServiceImpl } from '../../service/company-keyword-service-impl/company-keyword-service-impl';
import { CompanyKeywordRepositoryImpl } from '../../repository/company-keyword-repository-impl/company-keyword-repository-impl';
import { TenderKeywordCategoryServiceImpl } from '../../service/tender-keyword-category-service-impl/tender-keyword-category-service-impl';
import { TenderKeywordCategoryRepositoryImpl } from '../../repository/tender-keyword-category-repository-impl/tender-keyword-category-repository-impl';

@Module({
    imports: [forwardRef(() => DrizzleModule),MercadoPublicoGirosModule,forwardRef(() =>  CompanyModule)],
    controllers: [KeywordController],
    providers: [
        {
            provide: 'KeywordService',
            useClass: KeywordServiceImpl,
        },
        {
            provide: 'KeywordRepository',
            useClass: KeywordRepositoryImpl,
        },
        {
            provide: 'CompanyKeywordService',
            useClass: CompanyKeywordServiceImpl,
        },
        {
            provide: 'CompanyKeywordRepository',
            useClass: CompanyKeywordRepositoryImpl,
        },
        {
            provide: 'TenderKeywordCategoryService',
            useClass: TenderKeywordCategoryServiceImpl,
        },
        {
            provide: 'TenderKeywordCategoryRepository',
            useClass: TenderKeywordCategoryRepositoryImpl,
        }
    ],
    exports: [
        'KeywordService',
        'KeywordRepository',
        'CompanyKeywordService',
        'CompanyKeywordRepository',
        'TenderKeywordCategoryService',
        'TenderKeywordCategoryRepository',
    ],
})
export class KeywordModule {}
