import { forwardRef, Module } from '@nestjs/common';
import { DrizzleModule } from 'src/framework/infrastructure/drizzle';
import { MatchingWordController } from '../../controllers/matching_word/matching_word.controller';
import { MatchingWordRepositoryImpl } from '../../repository/matching_word-repository-impl/matching_word-repository-impl';
import { MatchingWordServiceImpl } from '../../service/matching_word-service-impl/matching_word-service-impl';
import { FwkCacheModule } from 'src/framework/infrastructure/module/fwk-cache/fwk-cache.module';
import { GeoModule } from 'src/framework';

@Module({
  imports: [DrizzleModule, forwardRef(() =>FwkCacheModule), forwardRef(() =>GeoModule)],
      controllers: [MatchingWordController],
      providers: [
          {
              provide: 'MatchingWordService',
              useClass: MatchingWordServiceImpl,
          },
          {
              provide: 'MatchingWordRepository',
              useClass: MatchingWordRepositoryImpl,
          },
      ],
      exports: [
          'MatchingWordService',
          'MatchingWordRepository',
      ],
})
export class MatchingWordModule {}
