import { Module } from '@nestjs/common';
import { DrizzleModule } from 'src/framework/infrastructure/drizzle';
import { ScheduleMpServiceImpl } from '../../service/schedule-mp-service-impl/schedule-mp-service-impl';
import { TenderModule } from '../tender/tender.module';
import { UserCampaignsModule } from 'src/framework/infrastructure/module/user-campaigns/user-campaigns.module';
import { NotificationRecordModule } from 'src/framework/infrastructure/module/notification-record/notification-record.module';
import { CompanyModule } from '../company/company.module';
import { UserCompanyAgileTenderModule } from '../user-company-agile-tender/user-company-agile-tender.module';
import { FwkCacheModule } from 'src/framework/infrastructure/module/fwk-cache/fwk-cache.module';
import { GeneralActionTenderController } from '../../controllers/general-action-tender/general-action-tender.controller';
import { NotificationModule, UserRequestModule, UserRoleModule } from 'src/framework';

@Module({
  imports: [
    DrizzleModule,
    TenderModule,
    NotificationModule,
    UserCampaignsModule,
    NotificationRecordModule,
    CompanyModule,
    UserCompanyAgileTenderModule,
    FwkCacheModule,
    UserRequestModule,
    UserRoleModule
  ],
  controllers: [GeneralActionTenderController],
  providers: [ScheduleMpServiceImpl],
  exports: [],
})
export class ScheduleMpModule {}
