import { forwardRef, Module } from '@nestjs/common';
import { DrizzleModule } from 'src/framework';
import { TenderKeywordCategoryController } from '../../controllers/tender-keyword-category/tender-keyword-category.controller';
import { TenderKeywordCategoryServiceImpl } from '../../service/tender-keyword-category-service-impl/tender-keyword-category-service-impl';
import { TenderKeywordCategoryRepositoryImpl } from '../../repository/tender-keyword-category-repository-impl/tender-keyword-category-repository-impl';
import { Keyword } from 'src/licitaapp/domain';
import { KeywordModule } from '../keyword/keyword.module';

@Module({
    imports: [forwardRef(() => DrizzleModule),KeywordModule],
    controllers: [TenderKeywordCategoryController],
    providers: [
        {
            provide: 'TenderKeywordCategoryService',
            useClass: TenderKeywordCategoryServiceImpl,
        },
        {
            provide: 'TenderKeywordCategoryRepository',
            useClass: TenderKeywordCategoryRepositoryImpl,
        },
    ],
    exports: [
        'TenderKeywordCategoryService',
        'TenderKeywordCategoryRepository',
    ],
})
export class TenderKeywordCategoryTenderModule {}
