import { Module } from '@nestjs/common';
import { DrizzleModule } from 'src/framework/infrastructure/drizzle';
import { UserCompanyAgileTenderServiceImpl } from '../../service/user-company-agile-tender-service-impl/user-company-agile-tender-service-impl';
import { UserCompanyAgileTenderRepositoryImpl } from '../../repository/user-company-agile-tender-repository-impl/user-company-agile-tender-repository-impl';
import { UserRequestModule } from 'src/framework';

@Module({
  imports: [DrizzleModule],
  providers: [
    {
      provide: 'UserCompanyAgileTenderService',
      useClass: UserCompanyAgileTenderServiceImpl,
    },
    {
      provide: 'UserCompanyAgileTenderRepository',
      useClass: UserCompanyAgileTenderRepositoryImpl,
    },
  ],
  exports: [
    'UserCompanyAgileTenderService',
    'UserCompanyAgileTenderRepository',
  ],
})
export class UserCompanyAgileTenderModule {}
