import { forwardRef, Module } from '@nestjs/common';
import { DrizzleModule } from 'src/framework/infrastructure/drizzle';
import { UserServiceImpl } from '../../../../framework/infrastructure/service/user-service-impl/user-service-impl';
import { UserRepositoryImpl } from '../../../../framework/infrastructure/repository/user-repository-impl/user-repository-impl';
import { AccessImplService } from '../../../../framework/infrastructure/service';
import { UserController } from 'src/framework/infrastructure/controllers/user/user.controller';
import { NotificationModule, RoleModule, UserRoleModule } from 'src/framework';
import { AccessController } from 'src/framework/infrastructure/controllers/access/access.controller';

@Module({
    imports: [forwardRef(() => DrizzleModule), forwardRef(() => UserRoleModule), forwardRef(() => RoleModule), forwardRef(() => NotificationModule)],
    controllers: [UserController, AccessController],
    providers: [
      {
        provide: 'UserRepository',
        useClass: UserRepositoryImpl,
      },
      {
        provide: 'UserService',
        useClass: UserServiceImpl,
      },
      {
        provide: 'AccessService',
        useClass: AccessImplService,
      },
      
    ],
    exports: [
      'UserRepository',
      'UserService',
      'AccessService',
      //APP_GUARD,
    ],
  })
export class UserModule {}
