import { Inject, Injectable } from '@nestjs/common';
import { PrimeLogger, TxType } from 'src/framework';
import { CompanyKeywordService } from 'src/licitaapp/application/service/company-keyword-service/company-keyword-service.interface';
import { CompanyKeywordRepository } from 'src/licitaapp/application/repository/company-keyword-repository/company-keyword-repository.interface';
import { Keyword } from 'src/licitaapp/domain';

@Injectable()
export class CompanyKeywordServiceImpl implements CompanyKeywordService {
    private readonly LOGGER = new PrimeLogger(CompanyKeywordServiceImpl.name);
    constructor(
        @Inject('CompanyKeywordRepository')
        private readonly companyKeywordRepository: CompanyKeywordRepository,
    ) {}
    findByCompanyId(companyId: number, tx?: TxType): Promise<Keyword[]> {
        this.LOGGER.log(`findByCompanyId companyId: ${companyId}`);
        return this.companyKeywordRepository.findByCompanyId(companyId, tx);
    }
    deleteByCompanyAndKeywordId(companyId: number, keywordId: number, tx?: TxType): Promise<void> {
        this.LOGGER.log(`deleteByCompanyAndKeywordId companyId: ${companyId} keywordId: ${keywordId}`);
        return this.companyKeywordRepository.deleteByCompanyAndKeywordId(companyId, keywordId, tx);
    }
    deleteByCompanyId(companyId: number, tx?: TxType): Promise<void> {
        this.LOGGER.log(`deleteByCompanyId companyId: ${companyId}`);
        return this.companyKeywordRepository.deleteByCompanyId(companyId, tx);
    }
    saveAll(companyId: number, keywordId: number[], tx?: TxType): Promise<void> {
        this.LOGGER.log(`saveAll companyId: ${companyId} keywordId: ${keywordId}`);
        return this.companyKeywordRepository.saveAll(companyId, keywordId, tx);
    }

}
