import { Inject, Injectable } from '@nestjs/common';
import { PrimeLogger } from 'src/framework';
import { AgileTenderTO } from 'src/licitaapp/application';
import { HistoryAgileTenderRepository } from 'src/licitaapp/application/repository/history-agile-tender-repository/history-agile-tender-repository.interface';
import { HistoryAgileTenderService } from 'src/licitaapp/application/service/history-agile-tender-service/history-agile-tender-service.interface';
import { AgileTender } from 'src/licitaapp/domain';
import { UserHistoryAgileTenderRow } from 'src/licitaapp/domain/type/user-history-agile-tender.types';

@Injectable()
export class HistoryAgileTenderServiceImpl implements HistoryAgileTenderService {
    private readonly LOGGER = new PrimeLogger(HistoryAgileTenderServiceImpl.name);
    constructor(
        @Inject('HistoryAgileTenderRepository')
        private readonly historyAgileTenderRepository: HistoryAgileTenderRepository,
    ) {}
    updateFavoriteUserCompanyAgileTender(userId: number, companyId: number, agileTenderId: number, isFavorite: boolean): Promise<void> {
        this.LOGGER.log(`updateFavoriteUserCompanyAgileTender - userId: ${userId}, companyId: ${companyId}, agileTenderId: ${agileTenderId}, isFavorite: ${isFavorite}`);
        return this.historyAgileTenderRepository.updateFavoriteUserCompanyAgileTender(userId, companyId, agileTenderId, isFavorite);
    }
    getTenderAgilePaginated(userId: number, page: number, pageSize: number, companyId: number, searchType: string): Promise<AgileTenderTO[]> {
        this.LOGGER.log(`getTenderAgilePaginated - userId: ${userId}, page: ${page}, pageSize: ${pageSize}, companyId: ${companyId}, searchType: ${searchType}`);
        return this.historyAgileTenderRepository.getTenderAgilePaginated(userId, page, pageSize, companyId, searchType);
    }
    save(userId: number, tenderAgileId: number): Promise<boolean> {
        this.LOGGER.log(`Save - userId: ${userId}, tenderAgileId: ${tenderAgileId}`);
        return this.historyAgileTenderRepository.save(userId, tenderAgileId);
    }
    erraseUserAgileHistoryTender(tenderInfo: AgileTender): Promise<void> {
        this.LOGGER.log(`erraseUserAgileHistoryTender - tenderId: ${tenderInfo.code}`);
        return this.historyAgileTenderRepository.erraseUserAgileHistoryTender(tenderInfo);
    }
    findByUserAgileTender(userId: number, tenderAgileId: number): Promise<UserHistoryAgileTenderRow | undefined> {
        this.LOGGER.log(`findByUserAgileTender - userId: ${userId}, tenderAgileId: ${tenderAgileId}`);
        return this.historyAgileTenderRepository.findByUserAgileTender(userId, tenderAgileId);
    }
    updateFavoriteUserCompanyAgiletender(userId: number, companyId: number, agileTenderId: number, isFavorite: boolean): Promise<void> {
        throw new Error('Method not implemented.');
    }
      
}
