import { Inject, Injectable } from '@nestjs/common';
import { PrimeLogger } from 'src/framework';
import { KeywordAgileTenderRepository } from 'src/licitaapp/application/repository/keyword-agile-tender-repository/keyword-agile-tender-repository.interface';
import { KeywordAgileTenderService } from 'src/licitaapp/application/service/keyword-agile-tender-service/keyword-agile-tender-service.interface';
import { AgileKeyword, InsertAgileKeyword } from 'src/licitaapp/domain';

@Injectable()
export class KeywordAgileTenderServiceImpl implements KeywordAgileTenderService {
    private readonly LOGGER = new PrimeLogger(KeywordAgileTenderServiceImpl.name);
    constructor(
    @Inject('KeywordAgileTenderRepository')
    private readonly agileKeywordRepository: KeywordAgileTenderRepository,
    ) {}
    getAgileTenderByWord(word: string): Promise<String[]> {
        this.LOGGER.log(`getAgileTenderByWord word: ${word}`);
        return this.agileKeywordRepository.getAgileTenderByWord(word);
    }
    findAdminValues(): Promise<string[]> {
        this.LOGGER.log(`findAdminValues`);
        return this.agileKeywordRepository.findAdminValues();
    }
    findByAgileTenderId(agileTenderId: number): Promise<AgileKeyword[]> {
        this.LOGGER.log(`findByAgileTenderId agileTenderId: ${agileTenderId}`);
        return this.agileKeywordRepository.findByAgileTenderId(agileTenderId);
    }
    logicalRemove(keywordAgileTenderId: number): Promise<void> {
        this.LOGGER.log(`logicalRemove keywordAgileTenderId: ${keywordAgileTenderId}`);
        return this.agileKeywordRepository.logicalRemove(keywordAgileTenderId);
    }
    save(data: InsertAgileKeyword, userId: number): Promise<AgileKeyword> {
        this.LOGGER.log(`save keyword: ${JSON.stringify(data)}`);
        return this.agileKeywordRepository.save(data, userId);
    }
}
