import { Inject, Injectable } from '@nestjs/common';
import { PrimeLogger } from 'src/framework';
import { KeywordService } from 'src/licitaapp/application';
import { TenderKeywordCategoryRepository } from 'src/licitaapp/application/repository/tender-keyword-category-repository/tender-keyword-category-repository.interface';
import { TenderKeywordCategoryService } from 'src/licitaapp/application/service/tender-keyword-category-service/tender-keyword-category-service.interface';
import { InsertTenderKeywordCategory } from 'src/licitaapp/domain/entities/tender-keyword-category.entity';

@Injectable()
export class TenderKeywordCategoryServiceImpl implements TenderKeywordCategoryService {
    private readonly LOGGER = new PrimeLogger(TenderKeywordCategoryServiceImpl.name);
    constructor(
        @Inject('TenderKeywordCategoryRepository')
        private readonly tenderKeywordCategoryRepository: TenderKeywordCategoryRepository,
    ) {}
    async findAllByWordFilter(wordFilter: string[], returnNormalTender: boolean): Promise<number[]> {
        this.LOGGER.log(`findAllByWordFilter wordFilter: ${wordFilter} returnNormalTender: ${returnNormalTender}`);
        let results: number[] = [];
        for (const word of wordFilter) {
            const partialResults =  await this.tenderKeywordCategoryRepository.findAllByWordFilter(word, returnNormalTender);
            results = results.concat(partialResults);
        }
        return Array.from(new Set(results));
    }
    findAllByCodeMercadoPublico(codeMercadoPublico: number[], returnNormalTender: boolean): Promise<number[]> {
        this.LOGGER.log(`findAllByCodeMercadoPublico codeMercadoPublico: ${JSON.stringify(codeMercadoPublico)} returnNormalTender: ${returnNormalTender}`);
        return this.tenderKeywordCategoryRepository.findAllByCodeMercadoPublico(codeMercadoPublico, returnNormalTender);
    }
    saveAgileTenderCategory(tenderId: number, codeMercadoPublico: string, itemDescription: string): Promise<void> {
        this.LOGGER.log(`saveAgileTenderCategory tenderId: ${tenderId} codeMercadoPublico: ${JSON.stringify(codeMercadoPublico)}`);
        return this.tenderKeywordCategoryRepository.saveAgileTenderCategory(tenderId, codeMercadoPublico, itemDescription);
    }
    saveNormalTenderCategory(tenderId: number, codeMercadoPublico: string, itemDescription: string): Promise<void> {
        this.LOGGER.log(`saveNormalTenderCategory tenderId: ${tenderId} codeMercadoPublico: ${JSON.stringify(codeMercadoPublico)}`);
        return this.tenderKeywordCategoryRepository.saveNormalTenderCategory(tenderId, codeMercadoPublico, itemDescription);
    }
    upsert(tender: InsertTenderKeywordCategory): Promise<number> {
        this.LOGGER.log(`upsert tender: ${JSON.stringify(tender)}`);
        return this.tenderKeywordCategoryRepository.upsert(tender);
    }
    
}
