import { Inject, Injectable } from '@nestjs/common';
import { InsertUserRequest, PrimeLogger, UserRequestService } from 'src/framework';
import { AgileTenderFullInfoTO, AgileTenderTO } from 'src/licitaapp/application';
import { UserCompanyAgileTenderRepository } from 'src/licitaapp/application/repository/user-company-agile-tender-repository/user-company-agile-tender-repository.interface';
import { TenderService } from 'src/licitaapp/application/service/tender-service/tender-service.interface';
import { UserCompanyAgileTenderService } from 'src/licitaapp/application/service/user-company-agile-tender-service/user-company-agile-tender-service.interface';
import { AgileTender } from 'src/licitaapp/domain';

@Injectable()
export class UserCompanyAgileTenderServiceImpl
  implements UserCompanyAgileTenderService
{
  private readonly LOGGER = new PrimeLogger(
    UserCompanyAgileTenderServiceImpl.name,
  );
  constructor(
    @Inject('UserCompanyAgileTenderRepository')
    private readonly userCompanyAgileTenderRepository: UserCompanyAgileTenderRepository,
  ) {}
  findTenderByUserCompanyId(userId: number, companyId: number): Promise<AgileTender[]> {
    this.LOGGER.log(`findTenderByUserCompanyId - userId: ${userId}, companyId: ${companyId}`);        
    return this.userCompanyAgileTenderRepository.findTenderByUserCompanyId(userId, companyId);
  }
  countActiveTendersCompany(companyId: number): Promise<number> {
    this.LOGGER.log(`countActiveTendersCompany - companyId: ${companyId}`);
    return this.userCompanyAgileTenderRepository.countActiveTendersCompany(
      companyId,
    );
  }
  getFavoriteList(userId: number): Promise<number[]> {
    this.LOGGER.log(`getFavoriteList - userId: ${userId}`);
    return this.userCompanyAgileTenderRepository.getFavoriteList(userId);
  }
  erraseUserCompanyAgileTender(tenderAgileIds: number[]): Promise<void> {
    this.LOGGER.log(
      `erraseUserCompanyAgileTender - tenderAgileIds: ${tenderAgileIds}`,
    );
    return this.userCompanyAgileTenderRepository.erraseUserCompanyAgileTender(
      tenderAgileIds,
    );
  }
  async saveAll(
    userId: number,
    companyId: number,
    tenderIds: number[],
    isFavorite: boolean,
    agileCode?: string,
    userRequestService?: UserRequestService,
  ): Promise<boolean> {
    this.LOGGER.log(
      `saveAll - userId: ${userId}, companyId: ${companyId}, tenderIds: ${tenderIds} isFavorite: ${isFavorite}`,
    );

    if(isFavorite && userRequestService){
      this.LOGGER.log(`Creating user request for favorite agile tender - userId: ${userId}, companyId: ${companyId}, tenderIds: ${tenderIds}`);
      const dataSend = new InsertUserRequest();
      dataSend.companyId = companyId;
      dataSend.title = `Se ha marcado una compra ágil`;
      dataSend.description = `El usuario ha marcado como favorito la licitación ágil: ${agileCode}`;
      await userRequestService.createUserRequest(
        userId,
        dataSend
      );
    }
    return this.userCompanyAgileTenderRepository.saveAll(
      userId,
      companyId,
      tenderIds,
      isFavorite,
    );
  }
  getPaginatedAgileTenders(
    userId: number,
    companyId: number,
    page: number,
    pageSize: number,
    isFavorite: boolean,
  ): Promise<AgileTenderFullInfoTO[]> {
    this.LOGGER.log(
      `getPaginatedAgileTenders - userId: ${userId}, companyId: ${companyId}, page: ${page}, pageSize: ${pageSize}, isFavorite: ${isFavorite}`,
    );
    return this.userCompanyAgileTenderRepository.getPaginatedAgileTenders(
      userId,
      companyId,
      page,
      pageSize,
      isFavorite,
    );
  }
}
