import { Inject, Injectable } from '@nestjs/common';
import { PrimeLogger } from 'src/framework';
import { UserCompanyTenderRepository } from 'src/licitaapp/application/repository/user-company-tender-repository/user-company-tender-repository.interface';
import { TenderKeywordCategoryService } from 'src/licitaapp/application/service/tender-keyword-category-service/tender-keyword-category-service.interface';
import { UserCompanyTenderService } from 'src/licitaapp/application/service/user-company-tender-service/user-company-tender-service.interface';
import { HistoryTenderDetail, Tender, TenderTO } from 'src/licitaapp/domain';
import { TenderKeywordCategory } from 'src/licitaapp/domain/entities/tender-keyword-category.entity';

@Injectable()
export class UserCompanyTenderServiceImpl implements UserCompanyTenderService {
    private readonly LOGGER = new PrimeLogger(UserCompanyTenderServiceImpl.name);
    constructor(
        @Inject('UserCompanyTenderRepository') private readonly userCompanyTenderRepository: UserCompanyTenderRepository,
    ) {}
    erraseUserCompanyTender(tenderIds: TenderTO[]): Promise<void> {
        this.LOGGER.log(`erraseUserCompanyTender - tenderIds: ${tenderIds.length}`);
        return this.userCompanyTenderRepository.erraseUserCompanyTender(tenderIds);
    }
    saveAll(userId: number, companyId: number, tenderIds: number[], source: string): Promise<boolean> {
        this.LOGGER.log(`saveAll - userId: ${userId}, companyId: ${companyId}, tenderIds: ${tenderIds.length}, source: ${source}`);
        if(tenderIds.length === 0){
            return Promise.resolve(true);
        }
        return this.userCompanyTenderRepository.saveAll(userId, companyId, tenderIds, source);
    }
    updateFavoriteUserCompanyTender(userId: number, companyId: number, tenderId: number, isFavorite: boolean): Promise<void> {
        this.LOGGER.log(`updateFavoriteUserCompanyTender - userId: ${userId}, companyId: ${companyId}, tenderId: ${tenderId}, isFavorite: ${isFavorite}`);
        return this.userCompanyTenderRepository.updateFavoriteUserCompanyTender(userId, companyId, tenderId, isFavorite);
    }
    save(userId: number, companyId: number, tenderId: number, source: string, matchResult: string): Promise<boolean> {
        this.LOGGER.log(`save - userId: ${userId}, companyId: ${companyId}, tenderId: ${tenderId}, source: ${source}, matchResult: ${matchResult}`);
        return this.userCompanyTenderRepository.save(userId, companyId, tenderId, source, matchResult);
    }
    findAllUserIdWithTenders(): Promise<number[]> {
        this.LOGGER.log('findAllUserIdWithTenders - Retrieving all user IDs with tenders');
        return this.userCompanyTenderRepository.findAllUserIdWithTenders();
    }
    async findTenderByUserCompanyId(userId: number, companyId: number): Promise<Tender[]> {
        this.LOGGER.log(`findTenderByUserCompanyId - userId: ${userId}, companyId: ${companyId}`);        
        return this.userCompanyTenderRepository.findTenderByUserCompanyId(userId, companyId);
    }
    getPaginatedTenders(userId: number, companyId: number, page: number, pageSize: number, searchType: string, filterLabel: string): Promise<Tender[]> {
        this.LOGGER.log(`getPaginatedTenders - userId: ${userId}, companyId: ${companyId}, page: ${page}, pageSize: ${pageSize}, searchType: ${searchType}, filterLabel: ${filterLabel}`);
        return this.userCompanyTenderRepository.getPaginatedTenders(userId, companyId, page, pageSize, searchType, filterLabel);
    }
    getHistoryTendersFavorite(userId: number, dateRequest: Date): Promise<Tender[]> {
        this.LOGGER.log(`getHistoryTendersFavorite - userId: ${userId}, dateRequest: ${dateRequest}`);
        return this.userCompanyTenderRepository.getHistoryTendersFavorite(userId, dateRequest);
    }
    getPaginatedHistoryTenders(userId: number, page: number, pageSize: number): Promise<HistoryTenderDetail[]> {
        this.LOGGER.log(`getPaginatedHistoryTenders - userId: ${userId}, page: ${page}, pageSize: ${pageSize}`);
        return this.userCompanyTenderRepository.getPaginatedHistoryTenders(userId, page, pageSize);
    }
    logicalRemoveCompanyTenderUser(userId: number, companyId: number, tenderId: number): Promise<void> {
        this.LOGGER.log(`logicalRemoveCompanyTenderUser - userId: ${userId}, companyId: ${companyId}, tenderId: ${tenderId}`);
        return this.userCompanyTenderRepository.logicalRemoveCompanyTenderUser(userId, companyId, tenderId);
    }
    erraseJoinCompanyTender(companyId: number): Promise<void> {
        this.LOGGER.log(`erraseJoinCompanyTender - companyId: ${companyId}`);
        return this.userCompanyTenderRepository.erraseJoinCompanyTender(companyId);
    }
    countActiveTendersCompany(companyId: number): Promise<number> {
        this.LOGGER.log(`countActiveTendersCompany - companyId: ${companyId}`);
        return this.userCompanyTenderRepository.countActiveTendersCompany(companyId);
    }
    getUsersIdsByCompanyId(companyId: number): Promise<number[]> {
        this.LOGGER.log(`getUsersIdsByCompanyId - companyId: ${companyId}`);
        return this.userCompanyTenderRepository.getUsersIdsByCompanyId(companyId);
    }
   
}
